<?php
include ('class.ezpdf.php');
include 'includes/config.php';
include 'defs.php';
$pdf = new Cezpdf('A4','landscape');
$pdf->selectFont('fonts/Times-Roman.afm');
$pdf->addJpegFromFile('images/logo1.jpg',40,520,55);
$date1=Date("j-n-Y");
$pdf->ezSetDy(-90);
$pdf->ezStartPageNumbers(800, 16, 9, 'right', '', 1);
$pdf->setColor(0.72, 0.72, 0.72);
$pdf->filledRectangle(220, 805, 160, 20, 'rgb');
$pdf->setColor(0,0,0);
$pdf->addText(290,560,13,"<b>GULF LUBE AHMAD ULLAH KHAN BROTHERS</b>");
$pdf->addText(330,545,12,"<b>(SALES REPORT WAREHOUSE-WISE)</b>");

$usr=$_GET['usr'];
$strFrom=$_POST['strFrom'];
$strTo=$_POST['strTo'];
$ware=$_POST['sman']; 
$prod=$_POST['prov'];




if ($strFrom=='')
{
$nResult = MySQLi_Query($link, "select MIN(Inv_Date) as dte from cust_sales");
while($rstRow = mysqli_fetch_array($nResult))
{
$strFrom=$rstRow['dte'];
}
}

$fdate=date('d-m-Y',strtotime($strFrom));
$tdate=date('d-m-Y',strtotime($strTo));

$date1 = new DateTime("2023-01-01");
$date2 = new DateTime(); // current date
$interval = $date1->diff($date2);
$days = $interval->days;

$header = $pdf->openObject();
$pdf->addText(20, 16, 10, "<b>Contact us @</b> Sabzal Road - Block No 3, STN Colony, Near Spini Road, Quetta (+92 81 2873538)");
$pdf->addText(20, 30, 10, "<b>_________________________________________________________________________________________________________________________________________________________________</b>");

$pdf->closeObject();
$pdf->addObject($header, "all");




if(!$ware)
{
$pdf->addText(20,500,11,"<b>Warehouses = </b> Karachi - Lahore - Quetta");

$pdf->addText(20,485,11,"<b>From = </b>            $fdate <b> To: </b> $tdate ");

$count=0;
$one=1;


$nResult = mysqli_query($link, "
    SELECT * FROM cust_sales 
    WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' 
    ORDER BY Inv_Det, Inv_Date, Id
");

$currentInv = '';
$grandTotal = 0;
$grandCarton = 0;
$grandLiters = 0;
$grandDiscount = 0;
$grandNetTotal = 0;

$count = 0;

$cols = array(
    'num' => '<b>S. No</b>',
    'dte' => '<b>Date</b>',
    'name' => '<b>Product Name</b>',
    'lit' => '<b>Liters</b>',
    'cart' => '<b>Cartons</b>',
    'rate' => '<b>Price</b>',
    'tot' => '<b>Total</b>',
    'dis' => '<b>Discount</b>',
    'ntot' => '<b>Net Amount</b>',
    'cty' => '<b>City</b>',
    'ware1' => '<b>Warehouse</b>',
    'sman1' => '<b>Salesman</b>',
    'stpe' => '<b>Inv-Type</b>'
);

$tableStyle = array(
    'xPos' => 20,
    'xOrientation' => 'right',
    'fontSize' => 8,
    'width' => 680,
    'showHeadings' => 1,
    'shaded' => 0,
    'showLines' => 2,
    'cols' => array(
        'num' => array('justification' => 'center', 'width' => 38),
        'dte' => array('justification' => 'center', 'width' => 55),
        'name' => array('justification' => 'left', 'width' => 145),
        'lit' => array('justification' => 'right', 'width' => 42),
        'cart' => array('justification' => 'right', 'width' => 42),
        'rate' => array('justification' => 'right', 'width' => 42),
        'tot' => array('justification' => 'right', 'width' => 55),
        'dis' => array('justification' => 'right', 'width' => 52),
        'ntot' => array('justification' => 'right', 'width' => 55),
        'cty' => array('justification' => 'center', 'width' => 90),
        'ware1' => array('justification' => 'center', 'width' => 55),
        'sman1' => array('justification' => 'left', 'width' => 90),
        'stpe' => array('justification' => 'left', 'width' => 60),
    )
);

while ($rstRow = mysqli_fetch_array($nResult)) {
    $idate = date("d-m-Y", strtotime($rstRow['Inv_Date']));
    $invDet = $rstRow['Inv_Det'];
    $cust = $rstRow['Customer'];

    // When invoice changes, print previous table and totals
    if ($currentInv != $invDet) {

        // Print previous invoice subtotal (if not first)
        if ($currentInv != '') {
            $data[] = array(
                'num' => '',
                'dte' => '',
                'name' => '<b>Sub Total</b>',
                'lit' => number_format($subLiters, 2),
                'cart' => number_format($subCarton, 2),
                'rate' => '',
                'tot' => number_format($subTotal, 2),
                'dis' => number_format($subDiscount, 2),
                'ntot' => number_format($subNetTotal, 2),
                'cty' => '',
                'ware1' => '',
                'sman1' => '',
                'stpe' => ''
            );
            $pdf->ezTable($data, $cols, '', $tableStyle);
            $pdf->ezText("\n", 8);
        }

        // Print invoice header before table
        $pdf->ezText("<b>Invoice #:</b> $invDet", 10);
        $pdf->ezText("<b>Customer:</b> $cust", 10);
        $pdf->ezText("\n", 5);

        // Reset per-invoice totals
        $data = array();
        $count = 0;
        $subTotal = 0;
        $subCarton = 0;
        $subLiters = 0;
        $subDiscount = 0;
        $subNetTotal = 0;

        $currentInv = $invDet;
    }

    // Determine invoice type
    $sts = ($rstRow['Inv_N'] == 'SIR') ? 'Sales Return' : 'Sales';

    $count++;
    $data[] = array(
        'num' => $count,
        'dte' => $idate,
        'name' => $rstRow['Name'],
        'lit' => $rstRow['Qty'],
        'cart' => $rstRow['Carton'],
        'rate' => number_format($rstRow['Rate'], 2),
        'tot' => number_format($rstRow['Total'], 2),
        'dis' => number_format($rstRow['R_Dis'], 2),
        'ntot' => number_format($rstRow['N_Total'], 2),
        'cty' => $rstRow['City'],
        'ware1' => $rstRow['Warehouse'],
        'sman1' => $rstRow['Salesman'],
        'stpe' => $sts
    );

    // Per-invoice totals
    $subTotal += $rstRow['Total'];
    $subCarton += $rstRow['Carton'];
    $subLiters += $rstRow['Qty'];
    $subDiscount += $rstRow['R_Dis'];
    $subNetTotal += $rstRow['N_Total'];

    // Grand totals
    $grandTotal += $rstRow['Total'];
    $grandCarton += $rstRow['Carton'];
    $grandLiters += $rstRow['Qty'];
    $grandDiscount += $rstRow['R_Dis'];
    $grandNetTotal += $rstRow['N_Total'];
}

// Print last invoice table
if (!empty($data)) {
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Sub Total</b>',
        'lit' => number_format($subLiters, 2),
        'cart' => number_format($subCarton, 2),
        'rate' => '',
        'tot' => number_format($subTotal, 2),
        'dis' => number_format($subDiscount, 2),
        'ntot' => number_format($subNetTotal, 2),
        'cty' => '',
        'ware1' => '',
        'sman1' => '',
        'stpe' => ''
    );
    $pdf->ezTable($data, $cols, '', $tableStyle);
    $pdf->ezText("\n", 8);
}
/*
// Print Grand Total summary
$pdf->ezText("<b>GRAND TOTAL SUMMARY</b>", 10);
$pdf->ezText("<b>Total Liters:</b> " . number_format($grandLiters, 2), 9);
$pdf->ezText("<b>Total Cartons:</b> " . number_format($grandCarton, 2), 9);
$pdf->ezText("<b>Total Amount:</b> " . number_format($grandTotal, 2), 9);
$pdf->ezText("<b>Total Discount:</b> " . number_format($grandDiscount, 2), 9);
$pdf->ezText("<b>Grand Net Total:</b> " . number_format($grandNetTotal, 2), 9);
*/


}




else
{
$pdf->addText(20,500,11,"<b>Warehouse = </b>  $ware");

$pdf->addText(20,485,11,"<b>From = </b>            $fdate <b> To: </b> $tdate ");

$nResult = mysqli_query($link, "
    SELECT * FROM cust_sales 
    WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' and Warehouse='$ware' 
    ORDER BY Inv_Det, Inv_Date, Id
");

$currentInv = '';
$grandTotal = 0;
$grandCarton = 0;
$grandLiters = 0;
$grandDiscount = 0;
$grandNetTotal = 0;

$count = 0;

$cols = array(
    'num' => '<b>S. No</b>',
    'dte' => '<b>Date</b>',
    'name' => '<b>Product Name</b>',
    'lit' => '<b>Liters</b>',
    'cart' => '<b>Cartons</b>',
    'rate' => '<b>Price</b>',
    'tot' => '<b>Total</b>',
    'dis' => '<b>Discount</b>',
    'ntot' => '<b>Net Amount</b>',
    'cty' => '<b>City</b>',
    'ware1' => '<b>Warehouse</b>',
    'sman1' => '<b>Salesman</b>',
    'stpe' => '<b>Inv-Type</b>'
);

$tableStyle = array(
    'xPos' => 20,
    'xOrientation' => 'right',
    'fontSize' => 8,
    'width' => 680,
    'showHeadings' => 1,
    'shaded' => 0,
    'showLines' => 2,
    'cols' => array(
        'num' => array('justification' => 'center', 'width' => 38),
        'dte' => array('justification' => 'center', 'width' => 55),
        'name' => array('justification' => 'left', 'width' => 145),
        'lit' => array('justification' => 'right', 'width' => 42),
        'cart' => array('justification' => 'right', 'width' => 42),
        'rate' => array('justification' => 'right', 'width' => 42),
        'tot' => array('justification' => 'right', 'width' => 55),
        'dis' => array('justification' => 'right', 'width' => 52),
        'ntot' => array('justification' => 'right', 'width' => 55),
        'cty' => array('justification' => 'center', 'width' => 90),
        'ware1' => array('justification' => 'center', 'width' => 55),
        'sman1' => array('justification' => 'left', 'width' => 90),
        'stpe' => array('justification' => 'left', 'width' => 60),
    )
);

while ($rstRow = mysqli_fetch_array($nResult)) {
    $idate = date("d-m-Y", strtotime($rstRow['Inv_Date']));
    $invDet = $rstRow['Inv_Det'];
    $cust = $rstRow['Customer'];

    // When invoice changes, print previous table and totals
    if ($currentInv != $invDet) {

        // Print previous invoice subtotal (if not first)
        if ($currentInv != '') {
            $data[] = array(
                'num' => '',
                'dte' => '',
                'name' => '<b>Sub Total</b>',
                'lit' => number_format($subLiters, 2),
                'cart' => number_format($subCarton, 2),
                'rate' => '',
                'tot' => number_format($subTotal, 2),
                'dis' => number_format($subDiscount, 2),
                'ntot' => number_format($subNetTotal, 2),
                'cty' => '',
                'ware1' => '',
                'sman1' => '',
                'stpe' => ''
            );
            $pdf->ezTable($data, $cols, '', $tableStyle);
            $pdf->ezText("\n", 8);
        }

        // Print invoice header before table
        $pdf->ezText("<b>Invoice #:</b> $invDet", 10);
        $pdf->ezText("<b>Customer:</b> $cust", 10);
        $pdf->ezText("\n", 5);

        // Reset per-invoice totals
        $data = array();
        $count = 0;
        $subTotal = 0;
        $subCarton = 0;
        $subLiters = 0;
        $subDiscount = 0;
        $subNetTotal = 0;

        $currentInv = $invDet;
    }

    // Determine invoice type
    $sts = ($rstRow['Inv_N'] == 'SIR') ? 'Sales Return' : 'Sales';

    $count++;
    $data[] = array(
        'num' => $count,
        'dte' => $idate,
        'name' => $rstRow['Name'],
        'lit' => $rstRow['Qty'],
        'cart' => $rstRow['Carton'],
        'rate' => number_format($rstRow['Rate'], 2),
        'tot' => number_format($rstRow['Total'], 2),
        'dis' => number_format($rstRow['R_Dis'], 2),
        'ntot' => number_format($rstRow['N_Total'], 2),
        'cty' => $rstRow['City'],
        'ware1' => $rstRow['Warehouse'],
        'sman1' => $rstRow['Salesman'],
        'stpe' => $sts
    );

    // Per-invoice totals
    $subTotal += $rstRow['Total'];
    $subCarton += $rstRow['Carton'];
    $subLiters += $rstRow['Qty'];
    $subDiscount += $rstRow['R_Dis'];
    $subNetTotal += $rstRow['N_Total'];

    // Grand totals
    $grandTotal += $rstRow['Total'];
    $grandCarton += $rstRow['Carton'];
    $grandLiters += $rstRow['Qty'];
    $grandDiscount += $rstRow['R_Dis'];
    $grandNetTotal += $rstRow['N_Total'];
}

// Print last invoice table
if (!empty($data)) {
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Sub Total</b>',
        'lit' => number_format($subLiters, 2),
        'cart' => number_format($subCarton, 2),
        'rate' => '',
        'tot' => number_format($subTotal, 2),
        'dis' => number_format($subDiscount, 2),
        'ntot' => number_format($subNetTotal, 2),
        'cty' => '',
        'ware1' => '',
        'sman1' => '',
        'stpe' => ''
    );
    $pdf->ezTable($data, $cols, '', $tableStyle);
    $pdf->ezText("\n", 8);
}




}






ob_clean();
$pdf->ezStream();
?>



