<?php
include ('class.ezpdf.php');
include 'includes/config.php';
include 'defs.php';
$pdf = new Cezpdf('A4','portrait');
$pdf->selectFont('fonts/Times-Roman.afm');
$pdf->addJpegFromFile('images/logo1.jpg',30,740,70);
//$pdf->addText(18,750,9,"MIS GENERATED REPORT");
$date1=Date("j-n-Y");
//$pdf->ezStartPageNumbers(526, 16, 10, 'right', '', 1);
$pdf->setColor(0.72, 0.72, 0.72);
$pdf->filledRectangle(220, 770, 160, 30, 'rgb');
$pdf->setColor(0,0,0);
$pdf->addText(275,780,13,"<b>(GLAKB)</b>");
$pdf->addText(200,755,12,"<b>(CUSTOMER-TYPE SALES REPORT)</b>");
$pdf->ezSetDy(-110);

$ctype=$_POST['ctype']; 
$sman=$_POST['sman']; 
$strFrom=$_POST['strFrom'];
$strTo=$_POST['strTo'];
$valu=$_POST['strn']; 



if ($strFrom=='')
{
$nResult = MySQLi_Query($link, "select MIN(Inv_Date) as dte from cust_sales");
while($rstRow = mysqli_fetch_array($nResult))
{
$strFrom=$rstRow['dte'];
}
}
$fdate=date('d-m-Y',strtotime($strFrom));
$tdate=date('d-m-Y',strtotime($strTo));


$strFrom=date('Y-m-d',strtotime($strFrom));
$strTo=date('Y-m-d',strtotime($strTo));

$pdf->addText(3,710,15,"___________________________________________________________________________________________________");

$pdf->addText(225,740,12,"<b>From $fdate to $tdate</b>");


if(!empty($ctype) && empty($sman) && $valu=='cart')
{
$rep_val = "Warecart";
}
elseif(!empty($ctype) && empty($sman) && $valu=='lit')
{
$rep_val = "Warelit";
} 


elseif(!empty($ctype) && !empty($sman) && $valu=='cart')
{
$rep_val = "Smancart";
}
elseif(!empty($ctype) && !empty($sman) && $valu=='lit')
{
$rep_val = "Smanlit";
} 


switch ($rep_val) {
case "Warecart":


$pdf->addText(30,715,12,"<b>Customer Type:</b>      $ctype");
$pdf->addText(460,715,12,"<b>Sales in Cartons.</b>");



$nResult = mysqli_query($link, "
    SELECT * FROM cust_sales 
    WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' 
      AND Inv_Type='$ctype' 
    ORDER BY Salesman, Inv_Date, Inv_Det, Id
");

$currentSalesman = '';
$count = 0;

// Totals
$subQty = $subDis = $subAmt = $subRet = 0;
$gQty = $gDis = $gAmt = $gRet = 0;

$data = array();

while ($rstRow = mysqli_fetch_array($nResult)) {
    $sman = $rstRow['Salesman'];

    // When salesman changes, print previous table
    if ($currentSalesman != '' && $currentSalesman != $sman) {

        // Subtotal row
        $data[] = array(
            'num' => '',
            'dte' => '',
            'name' => '<b>Subtotal</b>',
            'cust' => '',
            'ctn' => '<b>' . number_format($subQty, 2) . '</b>',
            'rate' => '',
            'dis' => '<b>' . number_format($subDis, 2) . '</b>',
            'ntot' => '<b>' . number_format($subAmt, 2) . '</b>'
        );

        // Sales Return row
        if ($subRet < 0) {
            $data[] = array(
                'num' => '',
                'dte' => '',
                'name' => '<b>Total Refund</b>',
                'cust' => '',
                'ctn' => '',
                'rate' => '',
                'dis' => '',
                'ntot' => '<b>' . number_format($subRet, 2) . '</b>'
            );
        }

        // Table Columns
        $cols = array(
            'num'  => '<b>S.No</b>',
            'dte'  => '<b>Date</b>',
            'name' => '<b>Product Name</b>',
            'cust' => '<b>Customer</b>',
            'ctn'  => '<b>Qty</b>',
            'rate' => '<b>Rate</b>',
            'dis'  => '<b>Discount</b>',
            'ntot' => '<b>Amount</b>'
        );

        // Print salesman table
           $pdf->ezSetDy(-5);
         $pdf->ezText("<b>$currentSalesman</b>", 11, array('justification' => 'left'));
         $pdf->ezSetDy(-5);
        $pdf->ezTable(
            $data,
            $cols,
            '',
            array(
                'xPos' => 20,
                'xOrientation' => 'right',
                'fontSize' => 8,
                'width' => 680,
                'showHeadings' => 1,
                'shaded' => 1,
                'showLines' => 1,
                'cols' => array(
                    'num'  => array('justification' => 'center', 'width' => 32),
                    'dte'  => array('justification' => 'center', 'width' => 55),
                    'name' => array('justification' => 'left',   'width' => 147),
                    'cust' => array('justification' => 'left',   'width' => 147),
                    'ctn'  => array('justification' => 'center', 'width' => 42),
                    'rate' => array('justification' => 'center', 'width' => 40),
                    'dis'  => array('justification' => 'center', 'width' => 52),
                    'ntot' => array('justification' => 'center', 'width' => 58)
                )
            )
        );
      

        // Reset subtotals
        $data = array();
        $subQty = $subDis = $subAmt = $subRet = 0;
    }

    $currentSalesman = $sman;
    $count++;

    $idate = date("d-m-Y", strtotime($rstRow['Inv_Date']));
    $qty   = $rstRow['Carton'];
    $dis   = $rstRow['R_Dis'];
    $amt   = $rstRow['N_Total'];

    // Add regular data row
    $data[] = array(
        'num'  => $count,
        'dte'  => $idate,
        'name' => $rstRow['Name'],
        'cust' => $rstRow['Customer'],
        'ctn'  => $qty,
        'rate' => $rstRow['Rate'],
        'dis'  => number_format($dis, 2),
        'ntot' => number_format($amt, 2)
    );

    // Totals
    $subQty += $qty;
    $subDis += $dis;

    if ($amt < 0) {
        $subRet += $amt;
        $gRet += $amt;
    } else {
        $subAmt += $amt;
        $gAmt += $amt;
    }

    $gQty += $qty;
    $gDis += $dis;
}

// Print final salesman section with Grand Total inside
if ($currentSalesman != '') {
    // Subtotal row
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Subtotal</b>',
        'cust' => '',
        'ctn' => '<b>' . number_format($subQty, 2) . '</b>',
        'rate' => '',
        'dis' => '<b>' . number_format($subDis, 2) . '</b>',
        'ntot' => '<b>' . number_format($subAmt, 2) . '</b>'
    );

    // Sales Return row (red)
    if ($subRet < 0) {
        $data[] = array(
            'num' => '',
            'dte' => '',
            'name' => '<b>Total Refund</b>',
            'cust' => '',
            'ctn' => '',
            'rate' => '',
            'dis' => '',
            'ntot' => '<b>' . number_format($subRet, 2) . '</b>'
        );
    }

    // Grand Total (blue)
    $netGrand = $gAmt + $gRet;
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Grand Total</b>',
        'cust' => '',
        'ctn' => '<b>' . number_format($gQty, 2) . '</b>',
        'rate' => '',
        'dis' => '<b>' . number_format($gDis, 2) . '</b>',
        'ntot' => '<b>' . number_format($netGrand, 2) . '</b>'
    );

    // Column titles
    $cols = array(
        'num'  => '<b>S.No</b>',
        'dte'  => '<b>Date</b>',
        'name' => '<b>Product Name</b>',
        'cust' => '<b>Customer</b>',
        'ctn'  => '<b>Qty</b>',
        'rate' => '<b>Rate</b>',
        'dis'  => '<b>Discount</b>',
        'ntot' => '<b>Amount</b>'
    );

  $pdf->ezSetDy(-5);
         $pdf->ezText("<b>$currentSalesman</b>", 11, array('justification' => 'left'));
         $pdf->ezSetDy(-5);
    $pdf->ezTable(
        $data,
        $cols,
        '',
        array(
            'xPos' => 20,
            'xOrientation' => 'right',
            'fontSize' => 8,
            'width' => 680,
            'showHeadings' => 1,
            'shaded' => 1,
            'showLines' => 1,
            'cols' => array(
                'num'  => array('justification' => 'center', 'width' => 32),
                'dte'  => array('justification' => 'center', 'width' => 55),
                'name' => array('justification' => 'left',   'width' => 147),
                'cust' => array('justification' => 'left',   'width' => 147),
                'ctn'  => array('justification' => 'center', 'width' => 42),
                'rate' => array('justification' => 'center', 'width' => 40),
                'dis'  => array('justification' => 'center', 'width' => 52),
                // 🔴 Red color for Sales Return, 🔵 Blue for Grand Total
                'ntot' => array(
                    'justification' => 'center',
                    'width' => 58,
                    'color' => array(0, 0, 0) // default black, rows inherit
                )
            )
        )
    );
}


$rst = mysqli_query($link, "SELECT Sum(Carton) as sumc, sum(N_Total) as sumr FROM cust_sales WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' 
      AND Inv_Type='$ctype' and Inv_N='SIR' ");
while ($rst1 = mysqli_fetch_array($rst)) 
{
$sumcart = $rst1['sumc'];
$sumret = $rst1['sumr'];
}

$ramt = $sumret * -1;
$tot_ret = $ramt + $netGrand;

$rpot = $sumcart * -1;
$totg = $rpot + $gQty;

$totg = number_format($totg,2);
$sumcart = number_format($sumcart,2);
$gQty = number_format($gQty,2);
$tot_ret = number_format($tot_ret,2);
$sumret = number_format($sumret,2);
$netGrand = number_format($netGrand,2);

$pdf->ezSetDy(-10);
$pdf->ezText("<b>OVERALL SALES DETAILS</b>",    11,["justification" => 'center']);
$pdf->ezSetDy(-5);
$pdf->ezText("<b>Gross Quantity:</b> $totg      |      <b>Refund Quantity:</b> $sumcart      |      <b>Net Sold Quantity:</b> $gQty",10,["justification" => 'left']);
$pdf->ezSetDy(-10);
$pdf->ezText("<b>Gross Sales in Amount:</b> $tot_ret      |      <b>Refund Sales in Amount:</b> $sumret",10,["justification" => 'left']);

$pdf->ezText("<b>__________________________________",10,["justification" => 'left']);
$pdf->ezSetDy(-5);
$pdf->ezText("<b>Net Sales in Amount:</b>     $netGrand",10,["justification" => 'left']);
$pdf->ezText("<b>__________________________________",10,["justification" => 'left']);


break;
case "Warelit":

$pdf->addText(30,715,12,"<b>Customer Type:</b>      $ctype");
$pdf->addText(460,715,12,"<b>Sales in Liters.</b>");



$nResult = mysqli_query($link, "
    SELECT * FROM cust_sales 
    WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' 
      AND Inv_Type='$ctype' 
    ORDER BY Salesman, Inv_Date, Inv_Det, Id
");

$currentSalesman = '';
$count = 0;

// Totals
$subQty = $subDis = $subAmt = $subRet = 0;
$gQty = $gDis = $gAmt = $gRet = 0;

$data = array();

while ($rstRow = mysqli_fetch_array($nResult)) {
    $sman = $rstRow['Salesman'];

    // When salesman changes, print previous table
    if ($currentSalesman != '' && $currentSalesman != $sman) {

        // Subtotal row
        $data[] = array(
            'num' => '',
            'dte' => '',
            'name' => '<b>Subtotal</b>',
            'cust' => '',
            'ctn' => '<b>' . number_format($subQty, 2) . '</b>',
            'rate' => '',
            'dis' => '<b>' . number_format($subDis, 2) . '</b>',
            'ntot' => '<b>' . number_format($subAmt, 2) . '</b>'
        );

        // Sales Return row
        if ($subRet < 0) {
            $data[] = array(
                'num' => '',
                'dte' => '',
                'name' => '<b>Total Refund</b>',
                'cust' => '',
                'ctn' => '',
                'rate' => '',
                'dis' => '',
                'ntot' => '<b>' . number_format($subRet, 2) . '</b>'
            );
        }

        // Table Columns
        $cols = array(
            'num'  => '<b>S.No</b>',
            'dte'  => '<b>Date</b>',
            'name' => '<b>Product Name</b>',
            'cust' => '<b>Customer</b>',
            'ctn'  => '<b>Qty</b>',
            'rate' => '<b>Rate</b>',
            'dis'  => '<b>Discount</b>',
            'ntot' => '<b>Amount</b>'
        );

        // Print salesman table
           $pdf->ezSetDy(-5);
         $pdf->ezText("<b>$currentSalesman</b>", 11, array('justification' => 'left'));
         $pdf->ezSetDy(-5);
        $pdf->ezTable(
            $data,
            $cols,
            '',
            array(
                'xPos' => 20,
                'xOrientation' => 'right',
                'fontSize' => 8,
                'width' => 680,
                'showHeadings' => 1,
                'shaded' => 1,
                'showLines' => 1,
                'cols' => array(
                    'num'  => array('justification' => 'center', 'width' => 32),
                    'dte'  => array('justification' => 'center', 'width' => 55),
                    'name' => array('justification' => 'left',   'width' => 147),
                    'cust' => array('justification' => 'left',   'width' => 147),
                    'ctn'  => array('justification' => 'center', 'width' => 42),
                    'rate' => array('justification' => 'center', 'width' => 40),
                    'dis'  => array('justification' => 'center', 'width' => 52),
                    'ntot' => array('justification' => 'center', 'width' => 58)
                )
            )
        );
      

        // Reset subtotals
        $data = array();
        $subQty = $subDis = $subAmt = $subRet = 0;
    }

    $currentSalesman = $sman;
    $count++;

    $idate = date("d-m-Y", strtotime($rstRow['Inv_Date']));
    $qty   = $rstRow['Qty'];
    $dis   = $rstRow['R_Dis'];
    $amt   = $rstRow['N_Total'];

    // Add regular data row
    $data[] = array(
        'num'  => $count,
        'dte'  => $idate,
        'name' => $rstRow['Name'],
        'cust' => $rstRow['Customer'],
        'ctn'  => $qty,
        'rate' => $rstRow['Rate'],
        'dis'  => number_format($dis, 2),
        'ntot' => number_format($amt, 2)
    );

    // Totals
    $subQty += $qty;
    $subDis += $dis;

    if ($amt < 0) {
        $subRet += $amt;
        $gRet += $amt;
    } else {
        $subAmt += $amt;
        $gAmt += $amt;
    }

    $gQty += $qty;
    $gDis += $dis;
}

// Print final salesman section with Grand Total inside
if ($currentSalesman != '') {
    // Subtotal row
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Subtotal</b>',
        'cust' => '',
        'ctn' => '<b>' . number_format($subQty, 2) . '</b>',
        'rate' => '',
        'dis' => '<b>' . number_format($subDis, 2) . '</b>',
        'ntot' => '<b>' . number_format($subAmt, 2) . '</b>'
    );

    // Sales Return row (red)
    if ($subRet < 0) {
        $data[] = array(
            'num' => '',
            'dte' => '',
            'name' => '<b>Total Refund</b>',
            'cust' => '',
            'ctn' => '',
            'rate' => '',
            'dis' => '',
            'ntot' => '<b>' . number_format($subRet, 2) . '</b>'
        );
    }

    // Grand Total (blue)
    $netGrand = $gAmt + $gRet;
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Grand Total</b>',
        'cust' => '',
        'ctn' => '<b>' . number_format($gQty, 2) . '</b>',
        'rate' => '',
        'dis' => '<b>' . number_format($gDis, 2) . '</b>',
        'ntot' => '<b>' . number_format($netGrand, 2) . '</b>'
    );

    // Column titles
    $cols = array(
        'num'  => '<b>S.No</b>',
        'dte'  => '<b>Date</b>',
        'name' => '<b>Product Name</b>',
        'cust' => '<b>Customer</b>',
        'ctn'  => '<b>Qty</b>',
        'rate' => '<b>Rate</b>',
        'dis'  => '<b>Discount</b>',
        'ntot' => '<b>Amount</b>'
    );

  $pdf->ezSetDy(-5);
         $pdf->ezText("<b>$currentSalesman</b>", 11, array('justification' => 'left'));
         $pdf->ezSetDy(-5);
    $pdf->ezTable(
        $data,
        $cols,
        '',
        array(
            'xPos' => 20,
            'xOrientation' => 'right',
            'fontSize' => 8,
            'width' => 680,
            'showHeadings' => 1,
            'shaded' => 1,
            'showLines' => 1,
            'cols' => array(
                'num'  => array('justification' => 'center', 'width' => 32),
                'dte'  => array('justification' => 'center', 'width' => 55),
                'name' => array('justification' => 'left',   'width' => 147),
                'cust' => array('justification' => 'left',   'width' => 147),
                'ctn'  => array('justification' => 'center', 'width' => 42),
                'rate' => array('justification' => 'center', 'width' => 40),
                'dis'  => array('justification' => 'center', 'width' => 52),
                // 🔴 Red color for Sales Return, 🔵 Blue for Grand Total
                'ntot' => array(
                    'justification' => 'center',
                    'width' => 58,
                    'color' => array(0, 0, 0) // default black, rows inherit
                )
            )
        )
    );
}


$rst = mysqli_query($link, "SELECT Sum(Qty) as sumc, sum(N_Total) as sumr FROM cust_sales WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' 
      AND Inv_Type='$ctype' and Inv_N='SIR' ");
while ($rst1 = mysqli_fetch_array($rst)) 
{
$sumcart = $rst1['sumc'];
$sumret = $rst1['sumr'];
}

$ramt = $sumret * -1;
$tot_ret = $ramt + $netGrand;

$rpot = $sumcart * -1;
$totg = $rpot + $gQty;

$totg = number_format($totg,2);
$sumcart = number_format($sumcart,2);
$gQty = number_format($gQty,2);
$tot_ret = number_format($tot_ret,2);
$sumret = number_format($sumret,2);
$netGrand = number_format($netGrand,2);

$pdf->ezSetDy(-10);
$pdf->ezText("<b>OVERALL SALES DETAILS</b>",    11,["justification" => 'center']);
$pdf->ezSetDy(-5);
$pdf->ezText("<b>Gross Quantity:</b> $totg      |      <b>Refund Quantity:</b> $sumcart      |      <b>Net Sold Quantity:</b> $gQty",10,["justification" => 'left']);
$pdf->ezSetDy(-10);
$pdf->ezText("<b>Gross Sales in Amount:</b> $tot_ret      |      <b>Refund Sales in Amount:</b> $sumret",10,["justification" => 'left']);

$pdf->ezText("<b>__________________________________",10,["justification" => 'left']);
$pdf->ezSetDy(-5);
$pdf->ezText("<b>Net Sales in Amount:</b>     $netGrand",10,["justification" => 'left']);
$pdf->ezText("<b>__________________________________",10,["justification" => 'left']);


break;
case "Smancart":


$pdf->addText(30,715,12,"<b>Customer Type:</b>   $ctype ");
$pdf->addText(460,715,12,"<b>Sales in Cartons.</b>");



$nResult = mysqli_query($link, "
    SELECT * FROM cust_sales 
    WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' 
      AND Salesman='$sman' and Inv_Type='$ctype' 
    ORDER BY Inv_Date, Inv_Det, Id
");

$currentSalesman = '';
$count = 0;

// Totals
$subQty = $subDis = $subAmt = $subRet = 0;
$gQty = $gDis = $gAmt = $gRet = 0;

$data = array();

while ($rstRow = mysqli_fetch_array($nResult)) {
    $sman = $rstRow['Salesman'];

    // When salesman changes, print previous table
    if ($currentSalesman != '' && $currentSalesman != $sman) {

        // Subtotal row
        $data[] = array(
            'num' => '',
            'dte' => '',
            'name' => '<b>Subtotal</b>',
            'cust' => '',
            'ctn' => '<b>' . number_format($subQty, 2) . '</b>',
            'rate' => '',
            'dis' => '<b>' . number_format($subDis, 2) . '</b>',
            'ntot' => '<b>' . number_format($subAmt, 2) . '</b>'
        );

        // Sales Return row
        if ($subRet < 0) {
            $data[] = array(
                'num' => '',
                'dte' => '',
                'name' => '<b>Total Refund</b>',
                'cust' => '',
                'ctn' => '',
                'rate' => '',
                'dis' => '',
                'ntot' => '<b>' . number_format($subRet, 2) . '</b>'
            );
        }

        // Table Columns
        $cols = array(
            'num'  => '<b>S.No</b>',
            'dte'  => '<b>Date</b>',
            'name' => '<b>Product Name</b>',
            'cust' => '<b>Customer</b>',
            'ctn'  => '<b>Qty</b>',
            'rate' => '<b>Rate</b>',
            'dis'  => '<b>Discount</b>',
            'ntot' => '<b>Amount</b>'
        );

        // Print salesman table
           $pdf->ezSetDy(-5);
         $pdf->ezText("<b>$currentSalesman</b>", 11, array('justification' => 'left'));
         $pdf->ezSetDy(-5);
        $pdf->ezTable(
            $data,
            $cols,
            '',
            array(
                'xPos' => 20,
                'xOrientation' => 'right',
                'fontSize' => 8,
                'width' => 680,
                'showHeadings' => 1,
                'shaded' => 1,
                'showLines' => 1,
                'cols' => array(
                    'num'  => array('justification' => 'center', 'width' => 32),
                    'dte'  => array('justification' => 'center', 'width' => 55),
                    'name' => array('justification' => 'left',   'width' => 147),
                    'cust' => array('justification' => 'left',   'width' => 147),
                    'ctn'  => array('justification' => 'center', 'width' => 42),
                    'rate' => array('justification' => 'center', 'width' => 40),
                    'dis'  => array('justification' => 'center', 'width' => 52),
                    'ntot' => array('justification' => 'center', 'width' => 58)
                )
            )
        );
      

        // Reset subtotals
        $data = array();
        $subQty = $subDis = $subAmt = $subRet = 0;
    }

    $currentSalesman = $sman;
    $count++;

    $idate = date("d-m-Y", strtotime($rstRow['Inv_Date']));
    $qty   = $rstRow['Carton'];
    $dis   = $rstRow['R_Dis'];
    $amt   = $rstRow['N_Total'];

    // Add regular data row
    $data[] = array(
        'num'  => $count,
        'dte'  => $idate,
        'name' => $rstRow['Name'],
        'cust' => $rstRow['Customer'],
        'ctn'  => $qty,
        'rate' => $rstRow['Rate'],
        'dis'  => number_format($dis, 2),
        'ntot' => number_format($amt, 2)
    );

    // Totals
    $subQty += $qty;
    $subDis += $dis;

    if ($amt < 0) {
        $subRet += $amt;
        $gRet += $amt;
    } else {
        $subAmt += $amt;
        $gAmt += $amt;
    }

    $gQty += $qty;
    $gDis += $dis;
}

// Print final salesman section with Grand Total inside
if ($currentSalesman != '') {
    // Subtotal row
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Subtotal</b>',
        'cust' => '',
        'ctn' => '<b>' . number_format($subQty, 2) . '</b>',
        'rate' => '',
        'dis' => '<b>' . number_format($subDis, 2) . '</b>',
        'ntot' => '<b>' . number_format($subAmt, 2) . '</b>'
    );

    // Sales Return row (red)
    if ($subRet < 0) {
        $data[] = array(
            'num' => '',
            'dte' => '',
            'name' => '<b>Total Refund</b>',
            'cust' => '',
            'ctn' => '',
            'rate' => '',
            'dis' => '',
            'ntot' => '<b>' . number_format($subRet, 2) . '</b>'
        );
    }

    // Grand Total (blue)
    $netGrand = $gAmt + $gRet;
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Grand Total</b>',
        'cust' => '',
        'ctn' => '<b>' . number_format($gQty, 2) . '</b>',
        'rate' => '',
        'dis' => '<b>' . number_format($gDis, 2) . '</b>',
        'ntot' => '<b>' . number_format($netGrand, 2) . '</b>'
    );

    // Column titles
    $cols = array(
        'num'  => '<b>S.No</b>',
        'dte'  => '<b>Date</b>',
        'name' => '<b>Product Name</b>',
        'cust' => '<b>Customer</b>',
        'ctn'  => '<b>Qty</b>',
        'rate' => '<b>Rate</b>',
        'dis'  => '<b>Discount</b>',
        'ntot' => '<b>Amount</b>'
    );

  $pdf->ezSetDy(-5);
         $pdf->ezText("<b>$currentSalesman</b>", 11, array('justification' => 'left'));
         $pdf->ezSetDy(-5);
    $pdf->ezTable(
        $data,
        $cols,
        '',
        array(
            'xPos' => 20,
            'xOrientation' => 'right',
            'fontSize' => 8,
            'width' => 680,
            'showHeadings' => 1,
            'shaded' => 1,
            'showLines' => 1,
            'cols' => array(
                'num'  => array('justification' => 'center', 'width' => 32),
                'dte'  => array('justification' => 'center', 'width' => 55),
                'name' => array('justification' => 'left',   'width' => 147),
                'cust' => array('justification' => 'left',   'width' => 147),
                'ctn'  => array('justification' => 'center', 'width' => 42),
                'rate' => array('justification' => 'center', 'width' => 40),
                'dis'  => array('justification' => 'center', 'width' => 52),
                // 🔴 Red color for Sales Return, 🔵 Blue for Grand Total
                'ntot' => array(
                    'justification' => 'center',
                    'width' => 58,
                    'color' => array(0, 0, 0) // default black, rows inherit
                )
            )
        )
    );
}


$rst = mysqli_query($link, "SELECT Sum(Carton) as sumc, sum(N_Total) as sumr FROM cust_sales WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' 
      AND Salesman='$sman' and Inv_Type='$ctype' and Inv_N='SIR' ");
while ($rst1 = mysqli_fetch_array($rst)) 
{
$sumcart = $rst1['sumc'];
$sumret = $rst1['sumr'];
}

$ramt = $sumret * -1;
$tot_ret = $ramt + $netGrand;

$rpot = $sumcart * -1;
$totg = $rpot + $gQty;

$totg = number_format($totg,2);
$sumcart = number_format($sumcart,2);
$gQty = number_format($gQty,2);
$tot_ret = number_format($tot_ret,2);
$sumret = number_format($sumret,2);
$netGrand = number_format($netGrand,2);

$pdf->ezSetDy(-10);
$pdf->ezText("<b>OVERALL SALES DETAILS</b>",    11,["justification" => 'center']);
$pdf->ezSetDy(-5);
$pdf->ezText("<b>Gross Quantity:</b> $totg      |      <b>Refund Quantity:</b> $sumcart      |      <b>Net Sold Quantity:</b> $gQty",10,["justification" => 'left']);
$pdf->ezSetDy(-10);
$pdf->ezText("<b>Gross Sales in Amount:</b> $tot_ret      |      <b>Refund Sales in Amount:</b> $sumret",10,["justification" => 'left']);

$pdf->ezText("<b>__________________________________",10,["justification" => 'left']);
$pdf->ezSetDy(-5);
$pdf->ezText("<b>Net Sales in Amount:</b>     $netGrand",10,["justification" => 'left']);
$pdf->ezText("<b>__________________________________",10,["justification" => 'left']);


break;
case "Smanlit":



$pdf->addText(30,715,12,"<b>Customer Type:</b>   $ctype ");
$pdf->addText(460,715,12,"<b>Sales in Liters.</b>");



$nResult = mysqli_query($link, "
    SELECT * FROM cust_sales 
    WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' 
      AND Salesman='$sman' and Inv_Type='$ctype' 
    ORDER BY Inv_Date, Inv_Det, Id
");

$currentSalesman = '';
$count = 0;

// Totals
$subQty = $subDis = $subAmt = $subRet = 0;
$gQty = $gDis = $gAmt = $gRet = 0;

$data = array();

while ($rstRow = mysqli_fetch_array($nResult)) {
    $sman = $rstRow['Salesman'];

    // When salesman changes, print previous table
    if ($currentSalesman != '' && $currentSalesman != $sman) {

        // Subtotal row
        $data[] = array(
            'num' => '',
            'dte' => '',
            'name' => '<b>Subtotal</b>',
            'cust' => '',
            'ctn' => '<b>' . number_format($subQty, 2) . '</b>',
            'rate' => '',
            'dis' => '<b>' . number_format($subDis, 2) . '</b>',
            'ntot' => '<b>' . number_format($subAmt, 2) . '</b>'
        );

        // Sales Return row
        if ($subRet < 0) {
            $data[] = array(
                'num' => '',
                'dte' => '',
                'name' => '<b>Total Refund</b>',
                'cust' => '',
                'ctn' => '',
                'rate' => '',
                'dis' => '',
                'ntot' => '<b>' . number_format($subRet, 2) . '</b>'
            );
        }

        // Table Columns
        $cols = array(
            'num'  => '<b>S.No</b>',
            'dte'  => '<b>Date</b>',
            'name' => '<b>Product Name</b>',
            'cust' => '<b>Customer</b>',
            'ctn'  => '<b>Qty</b>',
            'rate' => '<b>Rate</b>',
            'dis'  => '<b>Discount</b>',
            'ntot' => '<b>Amount</b>'
        );

        // Print salesman table
           $pdf->ezSetDy(-5);
         $pdf->ezText("<b>$currentSalesman</b>", 11, array('justification' => 'left'));
         $pdf->ezSetDy(-5);
        $pdf->ezTable(
            $data,
            $cols,
            '',
            array(
                'xPos' => 20,
                'xOrientation' => 'right',
                'fontSize' => 8,
                'width' => 680,
                'showHeadings' => 1,
                'shaded' => 1,
                'showLines' => 1,
                'cols' => array(
                    'num'  => array('justification' => 'center', 'width' => 32),
                    'dte'  => array('justification' => 'center', 'width' => 55),
                    'name' => array('justification' => 'left',   'width' => 147),
                    'cust' => array('justification' => 'left',   'width' => 147),
                    'ctn'  => array('justification' => 'center', 'width' => 42),
                    'rate' => array('justification' => 'center', 'width' => 40),
                    'dis'  => array('justification' => 'center', 'width' => 52),
                    'ntot' => array('justification' => 'center', 'width' => 58)
                )
            )
        );
      

        // Reset subtotals
        $data = array();
        $subQty = $subDis = $subAmt = $subRet = 0;
    }

    $currentSalesman = $sman;
    $count++;

    $idate = date("d-m-Y", strtotime($rstRow['Inv_Date']));
    $qty   = $rstRow['Qty'];
    $dis   = $rstRow['R_Dis'];
    $amt   = $rstRow['N_Total'];

    // Add regular data row
    $data[] = array(
        'num'  => $count,
        'dte'  => $idate,
        'name' => $rstRow['Name'],
        'cust' => $rstRow['Customer'],
        'ctn'  => $qty,
        'rate' => $rstRow['Rate'],
        'dis'  => number_format($dis, 2),
        'ntot' => number_format($amt, 2)
    );

    // Totals
    $subQty += $qty;
    $subDis += $dis;

    if ($amt < 0) {
        $subRet += $amt;
        $gRet += $amt;
    } else {
        $subAmt += $amt;
        $gAmt += $amt;
    }

    $gQty += $qty;
    $gDis += $dis;
}

// Print final salesman section with Grand Total inside
if ($currentSalesman != '') {
    // Subtotal row
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Subtotal</b>',
        'cust' => '',
        'ctn' => '<b>' . number_format($subQty, 2) . '</b>',
        'rate' => '',
        'dis' => '<b>' . number_format($subDis, 2) . '</b>',
        'ntot' => '<b>' . number_format($subAmt, 2) . '</b>'
    );

    // Sales Return row (red)
    if ($subRet < 0) {
        $data[] = array(
            'num' => '',
            'dte' => '',
            'name' => '<b>Total Refund</b>',
            'cust' => '',
            'ctn' => '',
            'rate' => '',
            'dis' => '',
            'ntot' => '<b>' . number_format($subRet, 2) . '</b>'
        );
    }

    // Grand Total (blue)
    $netGrand = $gAmt + $gRet;
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Grand Total</b>',
        'cust' => '',
        'ctn' => '<b>' . number_format($gQty, 2) . '</b>',
        'rate' => '',
        'dis' => '<b>' . number_format($gDis, 2) . '</b>',
        'ntot' => '<b>' . number_format($netGrand, 2) . '</b>'
    );

    // Column titles
    $cols = array(
        'num'  => '<b>S.No</b>',
        'dte'  => '<b>Date</b>',
        'name' => '<b>Product Name</b>',
        'cust' => '<b>Customer</b>',
        'ctn'  => '<b>Qty</b>',
        'rate' => '<b>Rate</b>',
        'dis'  => '<b>Discount</b>',
        'ntot' => '<b>Amount</b>'
    );

  $pdf->ezSetDy(-5);
         $pdf->ezText("<b>$currentSalesman</b>", 11, array('justification' => 'left'));
         $pdf->ezSetDy(-5);
    $pdf->ezTable(
        $data,
        $cols,
        '',
        array(
            'xPos' => 20,
            'xOrientation' => 'right',
            'fontSize' => 8,
            'width' => 680,
            'showHeadings' => 1,
            'shaded' => 1,
            'showLines' => 1,
            'cols' => array(
                'num'  => array('justification' => 'center', 'width' => 32),
                'dte'  => array('justification' => 'center', 'width' => 55),
                'name' => array('justification' => 'left',   'width' => 147),
                'cust' => array('justification' => 'left',   'width' => 147),
                'ctn'  => array('justification' => 'center', 'width' => 42),
                'rate' => array('justification' => 'center', 'width' => 40),
                'dis'  => array('justification' => 'center', 'width' => 52),
                // 🔴 Red color for Sales Return, 🔵 Blue for Grand Total
                'ntot' => array(
                    'justification' => 'center',
                    'width' => 58,
                    'color' => array(0, 0, 0) // default black, rows inherit
                )
            )
        )
    );
}


$rst = mysqli_query($link, "SELECT Sum(Qty) as sumc, sum(N_Total) as sumr FROM cust_sales WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' 
      AND Salesman='$sman' and Inv_Type='$ctype' and Inv_N='SIR' ");
while ($rst1 = mysqli_fetch_array($rst)) 
{
$sumcart = $rst1['sumc'];
$sumret = $rst1['sumr'];
}

$ramt = $sumret * -1;
$tot_ret = $ramt + $netGrand;

$rpot = $sumcart * -1;
$totg = $rpot + $gQty;

$totg = number_format($totg,2);
$sumcart = number_format($sumcart,2);
$gQty = number_format($gQty,2);
$tot_ret = number_format($tot_ret,2);
$sumret = number_format($sumret,2);
$netGrand = number_format($netGrand,2);

$pdf->ezSetDy(-10);
$pdf->ezText("<b>OVERALL SALES DETAILS</b>",    11,["justification" => 'center']);
$pdf->ezSetDy(-5);
$pdf->ezText("<b>Gross Quantity:</b> $totg      |      <b>Refund Quantity:</b> $sumcart      |      <b>Net Sold Quantity:</b> $gQty",10,["justification" => 'left']);
$pdf->ezSetDy(-10);
$pdf->ezText("<b>Gross Sales in Amount:</b> $tot_ret      |      <b>Refund Sales in Amount:</b> $sumret",10,["justification" => 'left']);

$pdf->ezText("<b>__________________________________",10,["justification" => 'left']);
$pdf->ezSetDy(-5);
$pdf->ezText("<b>Net Sales in Amount:</b>     $netGrand",10,["justification" => 'left']);
$pdf->ezText("<b>__________________________________",10,["justification" => 'left']);

break;
case "Custcart":


$pdf->addText(30,715,12,"<b>Customer:</b>      $cust");
$pdf->addText(460,715,12,"<b>Sales in Cartons.</b>");



$nResult = mysqli_query($link, "
    SELECT * FROM cust_sales 
    WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' 
      AND Customer='$cust' 
    ORDER BY Inv_Date, Inv_Det, Id
");

$currentSalesman = '';
$count = 0;

// Totals
$subQty = $subDis = $subAmt = $subRet = 0;
$gQty = $gDis = $gAmt = $gRet = 0;

$data = array();

while ($rstRow = mysqli_fetch_array($nResult)) {
    $sman = $rstRow['Salesman'];

    // When salesman changes, print previous table
    if ($currentSalesman != '' && $currentSalesman != $sman) {

        // Subtotal row
        $data[] = array(
            'num' => '',
            'dte' => '',
            'name' => '<b>Subtotal</b>',
            'cust' => '',
            'ctn' => '<b>' . number_format($subQty, 2) . '</b>',
            'rate' => '',
            'dis' => '<b>' . number_format($subDis, 2) . '</b>',
            'ntot' => '<b>' . number_format($subAmt, 2) . '</b>'
        );

        // Sales Return row
        if ($subRet < 0) {
            $data[] = array(
                'num' => '',
                'dte' => '',
                'name' => '<b>Total Refund</b>',
                'cust' => '',
                'ctn' => '',
                'rate' => '',
                'dis' => '',
                'ntot' => '<b>' . number_format($subRet, 2) . '</b>'
            );
        }

        // Table Columns
        $cols = array(
            'num'  => '<b>S.No</b>',
            'dte'  => '<b>Date</b>',
            'name' => '<b>Product Name</b>',
            'cust' => '<b>Customer</b>',
            'ctn'  => '<b>Qty</b>',
            'rate' => '<b>Rate</b>',
            'dis'  => '<b>Discount</b>',
            'ntot' => '<b>Amount</b>'
        );

        // Print salesman table
           $pdf->ezSetDy(-5);
         $pdf->ezText("<b>$currentSalesman</b>", 11, array('justification' => 'left'));
         $pdf->ezSetDy(-5);
        $pdf->ezTable(
            $data,
            $cols,
            '',
            array(
                'xPos' => 20,
                'xOrientation' => 'right',
                'fontSize' => 8,
                'width' => 680,
                'showHeadings' => 1,
                'shaded' => 1,
                'showLines' => 1,
                'cols' => array(
                    'num'  => array('justification' => 'center', 'width' => 32),
                    'dte'  => array('justification' => 'center', 'width' => 55),
                    'name' => array('justification' => 'left',   'width' => 147),
                    'cust' => array('justification' => 'left',   'width' => 147),
                    'ctn'  => array('justification' => 'center', 'width' => 42),
                    'rate' => array('justification' => 'center', 'width' => 40),
                    'dis'  => array('justification' => 'center', 'width' => 52),
                    'ntot' => array('justification' => 'center', 'width' => 58)
                )
            )
        );
      

        // Reset subtotals
        $data = array();
        $subQty = $subDis = $subAmt = $subRet = 0;
    }

    $currentSalesman = $sman;
    $count++;

    $idate = date("d-m-Y", strtotime($rstRow['Inv_Date']));
    $qty   = $rstRow['Carton'];
    $dis   = $rstRow['R_Dis'];
    $amt   = $rstRow['N_Total'];

    // Add regular data row
    $data[] = array(
        'num'  => $count,
        'dte'  => $idate,
        'name' => $rstRow['Name'],
        'cust' => $rstRow['Customer'],
        'ctn'  => $qty,
        'rate' => $rstRow['Rate'],
        'dis'  => number_format($dis, 2),
        'ntot' => number_format($amt, 2)
    );

    // Totals
    $subQty += $qty;
    $subDis += $dis;

    if ($amt < 0) {
        $subRet += $amt;
        $gRet += $amt;
    } else {
        $subAmt += $amt;
        $gAmt += $amt;
    }

    $gQty += $qty;
    $gDis += $dis;
}

// Print final salesman section with Grand Total inside
if ($currentSalesman != '') {
    // Subtotal row
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Subtotal</b>',
        'cust' => '',
        'ctn' => '<b>' . number_format($subQty, 2) . '</b>',
        'rate' => '',
        'dis' => '<b>' . number_format($subDis, 2) . '</b>',
        'ntot' => '<b>' . number_format($subAmt, 2) . '</b>'
    );

    // Sales Return row (red)
    if ($subRet < 0) {
        $data[] = array(
            'num' => '',
            'dte' => '',
            'name' => '<b>Total Refund</b>',
            'cust' => '',
            'ctn' => '',
            'rate' => '',
            'dis' => '',
            'ntot' => '<b>' . number_format($subRet, 2) . '</b>'
        );
    }

    // Grand Total (blue)
    $netGrand = $gAmt + $gRet;
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Grand Total</b>',
        'cust' => '',
        'ctn' => '<b>' . number_format($gQty, 2) . '</b>',
        'rate' => '',
        'dis' => '<b>' . number_format($gDis, 2) . '</b>',
        'ntot' => '<b>' . number_format($netGrand, 2) . '</b>'
    );

    // Column titles
    $cols = array(
        'num'  => '<b>S.No</b>',
        'dte'  => '<b>Date</b>',
        'name' => '<b>Product Name</b>',
        'cust' => '<b>Customer</b>',
        'ctn'  => '<b>Qty</b>',
        'rate' => '<b>Rate</b>',
        'dis'  => '<b>Discount</b>',
        'ntot' => '<b>Amount</b>'
    );

  $pdf->ezSetDy(-5);
         $pdf->ezText("<b>$currentSalesman</b>", 11, array('justification' => 'left'));
         $pdf->ezSetDy(-5);
    $pdf->ezTable(
        $data,
        $cols,
        '',
        array(
            'xPos' => 20,
            'xOrientation' => 'right',
            'fontSize' => 8,
            'width' => 680,
            'showHeadings' => 1,
            'shaded' => 1,
            'showLines' => 1,
            'cols' => array(
                'num'  => array('justification' => 'center', 'width' => 32),
                'dte'  => array('justification' => 'center', 'width' => 55),
                'name' => array('justification' => 'left',   'width' => 147),
                'cust' => array('justification' => 'left',   'width' => 147),
                'ctn'  => array('justification' => 'center', 'width' => 42),
                'rate' => array('justification' => 'center', 'width' => 40),
                'dis'  => array('justification' => 'center', 'width' => 52),
                // 🔴 Red color for Sales Return, 🔵 Blue for Grand Total
                'ntot' => array(
                    'justification' => 'center',
                    'width' => 58,
                    'color' => array(0, 0, 0) // default black, rows inherit
                )
            )
        )
    );
}


$rst = mysqli_query($link, "SELECT Sum(Carton) as sumc, sum(N_Total) as sumr FROM cust_sales WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' 
      AND Customer='$cust' and Inv_N='SIR' ");
while ($rst1 = mysqli_fetch_array($rst)) 
{
$sumcart = $rst1['sumc'];
$sumret = $rst1['sumr'];
}

$ramt = $sumret * -1;
$tot_ret = $ramt + $netGrand;

$rpot = $sumcart * -1;
$totg = $rpot + $gQty;

$totg = number_format($totg,2);
$sumcart = number_format($sumcart,2);
$gQty = number_format($gQty,2);
$tot_ret = number_format($tot_ret,2);
$sumret = number_format($sumret,2);
$netGrand = number_format($netGrand,2);

$pdf->ezSetDy(-10);
$pdf->ezText("<b>OVERALL SALES DETAILS</b>",    11,["justification" => 'center']);
$pdf->ezSetDy(-5);
$pdf->ezText("<b>Gross Quantity:</b> $totg      |      <b>Refund Quantity:</b> $sumcart      |      <b>Net Sold Quantity:</b> $gQty",10,["justification" => 'left']);
$pdf->ezSetDy(-10);
$pdf->ezText("<b>Gross Sales in Amount:</b> $tot_ret      |      <b>Refund Sales in Amount:</b> $sumret",10,["justification" => 'left']);

$pdf->ezText("<b>__________________________________",10,["justification" => 'left']);
$pdf->ezSetDy(-5);
$pdf->ezText("<b>Net Sales in Amount:</b>     $netGrand",10,["justification" => 'left']);
$pdf->ezText("<b>__________________________________",10,["justification" => 'left']);



break;
case "Custlit":


$pdf->addText(30,715,12,"<b>Customer:</b>      $cust");
$pdf->addText(460,715,12,"<b>Sales in Liters.</b>");



$nResult = mysqli_query($link, "
    SELECT * FROM cust_sales 
    WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' 
      AND Customer='$cust' 
    ORDER BY Inv_Date, Inv_Det, Id
");

$currentSalesman = '';
$count = 0;

// Totals
$subQty = $subDis = $subAmt = $subRet = 0;
$gQty = $gDis = $gAmt = $gRet = 0;

$data = array();

while ($rstRow = mysqli_fetch_array($nResult)) {
    $sman = $rstRow['Salesman'];

    // When salesman changes, print previous table
    if ($currentSalesman != '' && $currentSalesman != $sman) {

        // Subtotal row
        $data[] = array(
            'num' => '',
            'dte' => '',
            'name' => '<b>Subtotal</b>',
            'cust' => '',
            'ctn' => '<b>' . number_format($subQty, 2) . '</b>',
            'rate' => '',
            'dis' => '<b>' . number_format($subDis, 2) . '</b>',
            'ntot' => '<b>' . number_format($subAmt, 2) . '</b>'
        );

        // Sales Return row
        if ($subRet < 0) {
            $data[] = array(
                'num' => '',
                'dte' => '',
                'name' => '<b>Total Refund</b>',
                'cust' => '',
                'ctn' => '',
                'rate' => '',
                'dis' => '',
                'ntot' => '<b>' . number_format($subRet, 2) . '</b>'
            );
        }

        // Table Columns
        $cols = array(
            'num'  => '<b>S.No</b>',
            'dte'  => '<b>Date</b>',
            'name' => '<b>Product Name</b>',
            'cust' => '<b>Customer</b>',
            'ctn'  => '<b>Qty</b>',
            'rate' => '<b>Rate</b>',
            'dis'  => '<b>Discount</b>',
            'ntot' => '<b>Amount</b>'
        );

        // Print salesman table
           $pdf->ezSetDy(-5);
         $pdf->ezText("<b>$currentSalesman</b>", 11, array('justification' => 'left'));
         $pdf->ezSetDy(-5);
        $pdf->ezTable(
            $data,
            $cols,
            '',
            array(
                'xPos' => 20,
                'xOrientation' => 'right',
                'fontSize' => 8,
                'width' => 680,
                'showHeadings' => 1,
                'shaded' => 1,
                'showLines' => 1,
                'cols' => array(
                    'num'  => array('justification' => 'center', 'width' => 32),
                    'dte'  => array('justification' => 'center', 'width' => 55),
                    'name' => array('justification' => 'left',   'width' => 147),
                    'cust' => array('justification' => 'left',   'width' => 147),
                    'ctn'  => array('justification' => 'center', 'width' => 42),
                    'rate' => array('justification' => 'center', 'width' => 40),
                    'dis'  => array('justification' => 'center', 'width' => 52),
                    'ntot' => array('justification' => 'center', 'width' => 58)
                )
            )
        );
      

        // Reset subtotals
        $data = array();
        $subQty = $subDis = $subAmt = $subRet = 0;
    }

    $currentSalesman = $sman;
    $count++;

    $idate = date("d-m-Y", strtotime($rstRow['Inv_Date']));
    $qty   = $rstRow['Qty'];
    $dis   = $rstRow['R_Dis'];
    $amt   = $rstRow['N_Total'];

    // Add regular data row
    $data[] = array(
        'num'  => $count,
        'dte'  => $idate,
        'name' => $rstRow['Name'],
        'cust' => $rstRow['Customer'],
        'ctn'  => $qty,
        'rate' => $rstRow['Rate'],
        'dis'  => number_format($dis, 2),
        'ntot' => number_format($amt, 2)
    );

    // Totals
    $subQty += $qty;
    $subDis += $dis;

    if ($amt < 0) {
        $subRet += $amt;
        $gRet += $amt;
    } else {
        $subAmt += $amt;
        $gAmt += $amt;
    }

    $gQty += $qty;
    $gDis += $dis;
}

// Print final salesman section with Grand Total inside
if ($currentSalesman != '') {
    // Subtotal row
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Subtotal</b>',
        'cust' => '',
        'ctn' => '<b>' . number_format($subQty, 2) . '</b>',
        'rate' => '',
        'dis' => '<b>' . number_format($subDis, 2) . '</b>',
        'ntot' => '<b>' . number_format($subAmt, 2) . '</b>'
    );

    // Sales Return row (red)
    if ($subRet < 0) {
        $data[] = array(
            'num' => '',
            'dte' => '',
            'name' => '<b>Total Refund</b>',
            'cust' => '',
            'ctn' => '',
            'rate' => '',
            'dis' => '',
            'ntot' => '<b>' . number_format($subRet, 2) . '</b>'
        );
    }

    // Grand Total (blue)
    $netGrand = $gAmt + $gRet;
    $data[] = array(
        'num' => '',
        'dte' => '',
        'name' => '<b>Grand Total</b>',
        'cust' => '',
        'ctn' => '<b>' . number_format($gQty, 2) . '</b>',
        'rate' => '',
        'dis' => '<b>' . number_format($gDis, 2) . '</b>',
        'ntot' => '<b>' . number_format($netGrand, 2) . '</b>'
    );

    // Column titles
    $cols = array(
        'num'  => '<b>S.No</b>',
        'dte'  => '<b>Date</b>',
        'name' => '<b>Product Name</b>',
        'cust' => '<b>Customer</b>',
        'ctn'  => '<b>Qty</b>',
        'rate' => '<b>Rate</b>',
        'dis'  => '<b>Discount</b>',
        'ntot' => '<b>Amount</b>'
    );

  $pdf->ezSetDy(-5);
         $pdf->ezText("<b>$currentSalesman</b>", 11, array('justification' => 'left'));
         $pdf->ezSetDy(-5);
    $pdf->ezTable(
        $data,
        $cols,
        '',
        array(
            'xPos' => 20,
            'xOrientation' => 'right',
            'fontSize' => 8,
            'width' => 680,
            'showHeadings' => 1,
            'shaded' => 1,
            'showLines' => 1,
            'cols' => array(
                'num'  => array('justification' => 'center', 'width' => 32),
                'dte'  => array('justification' => 'center', 'width' => 55),
                'name' => array('justification' => 'left',   'width' => 147),
                'cust' => array('justification' => 'left',   'width' => 147),
                'ctn'  => array('justification' => 'center', 'width' => 42),
                'rate' => array('justification' => 'center', 'width' => 40),
                'dis'  => array('justification' => 'center', 'width' => 52),
                // 🔴 Red color for Sales Return, 🔵 Blue for Grand Total
                'ntot' => array(
                    'justification' => 'center',
                    'width' => 58,
                    'color' => array(0, 0, 0) // default black, rows inherit
                )
            )
        )
    );
}


$rst = mysqli_query($link, "SELECT Sum(Qty) as sumc, sum(N_Total) as sumr FROM cust_sales WHERE Inv_Date BETWEEN '$strFrom' AND '$strTo' 
      AND Customer='$cust' and Inv_N='SIR' ");
while ($rst1 = mysqli_fetch_array($rst)) 
{
$sumcart = $rst1['sumc'];
$sumret = $rst1['sumr'];
}

$ramt = $sumret * -1;
$tot_ret = $ramt + $netGrand;

$rpot = $sumcart * -1;
$totg = $rpot + $gQty;

$totg = number_format($totg,2);
$sumcart = number_format($sumcart,2);
$gQty = number_format($gQty,2);
$tot_ret = number_format($tot_ret,2);
$sumret = number_format($sumret,2);
$netGrand = number_format($netGrand,2);

$pdf->ezSetDy(-10);
$pdf->ezText("<b>OVERALL SALES DETAILS</b>",    11,["justification" => 'center']);
$pdf->ezSetDy(-5);
$pdf->ezText("<b>Gross Quantity:</b> $totg      |      <b>Refund Quantity:</b> $sumcart      |      <b>Net Sold Quantity:</b> $gQty",10,["justification" => 'left']);
$pdf->ezSetDy(-10);
$pdf->ezText("<b>Gross Sales in Amount:</b> $tot_ret      |      <b>Refund Sales in Amount:</b> $sumret",10,["justification" => 'left']);

$pdf->ezText("<b>__________________________________",10,["justification" => 'left']);
$pdf->ezSetDy(-5);
$pdf->ezText("<b>Net Sales in Amount:</b>     $netGrand",10,["justification" => 'left']);
$pdf->ezText("<b>__________________________________",10,["justification" => 'left']);


}


ob_clean();
$pdf->ezStream();
?>



