<?php
include ('class.ezpdf.php');
include 'includes/config.php';
include 'defs.php';
$pdf = new Cezpdf('A4','landscape');
$pdf->selectFont('fonts/Times-Roman.afm');
$pdf->addJpegFromFile('images/logo1.jpg',40,520,55);
$date1=Date("j-n-Y");
$pdf->ezSetDy(-90);
$pdf->ezStartPageNumbers(800, 16, 9, 'right', '', 1);
$pdf->setColor(0.72, 0.72, 0.72);
$pdf->filledRectangle(220, 805, 160, 20, 'rgb');
$pdf->setColor(0,0,0);
$pdf->addText(290,560,13,"<b>GULF LUBE AHMAD ULLAH KHAN BROTHERS</b>");
$pdf->addText(325,545,12,"<b>(COMPLETE PURCHASE INFORMATION)</b>");

$usr=$_GET['usr'];
$strFrom=$_POST['strFrom'];
$strTo=$_POST['strTo'];
$cmp=$_POST['comp']; 



if ($strFrom=='')
{
$nResult = MySQLi_Query($link, "select MIN(Inv_Date) as dte from p_details");
while($rstRow = mysqli_fetch_array($nResult))
{
$strFrom=$rstRow['dte'];
}
}

$fdate=date('d-m-Y',strtotime($strFrom));
$tdate=date('d-m-Y',strtotime($strTo));

$header = $pdf->openObject();
$pdf->addText(20, 16, 10, "<b>Contact us @</b> Sabzal Road - Block No 3, STN Colony, Near Spini Road, Quetta (+92 81 2873538)");
$pdf->addText(20, 30, 10, "<b>_________________________________________________________________________________________________________________________________________________________________</b>");

$pdf->closeObject();
$pdf->addObject($header, "all");


if(!$cmp)
{
$pdf->addText(20,500,12,"<b>Overall Purchases</b>");

$pdf->addText(20,485,11,"<b>From = </b>            $fdate <b> To: </b> $tdate ");

$count=0;
$one=1;
$nResult = MySQLi_Query($link, "Select * from p_details where Inv_Date between '$strFrom' and '$strTo' order by Inv_Date, Inv_No");

$count = 0;
$data = array();

// 👉 Initialize totals
$gtot = $gdis = $gft = $gst = $gntot = 0;

while($rstRow = mysqli_fetch_array($nResult))
{
    // running totals
    $gtot  += $rstRow['Total'];
    $gdis  += $rstRow['D_Amt'];
    $gft   += $rstRow['F_Amt'];
    $gst   += $rstRow['S_Amt'];
    $gntot += $rstRow['N_Total'];

    $idate = strtotime($rstRow['Inv_Date']);
    $idate = date("d-m-Y", $idate);

    $invn = $rstRow['Inv_N'];
    if($invn == 'PIB') {
        $sts = 'Sales';
    }
    if($invn == 'PIR') {
        $sts = 'Sales Return';
    }

    $count++;
    $data[] = array(
        'num'   => $count,
        'dte'   => $idate,
        'sts'   => $sts,
        'comp'  => $rstRow['Company'],
        'inv'   => $rstRow['Inv_Det'],
        'tot'   => number_format($rstRow['Total'],1),
        'dis'   => number_format($rstRow['D_Amt'],1),
        'ft'    => number_format($rstRow['F_Amt'],1),
        'st'    => number_format($rstRow['S_Amt'],1),
        'ntot'  => number_format($rstRow['N_Total'],1),
        'dc'    => $rstRow['DC_No'],
        'pc'    => $rstRow['Pur_No'],
        'ware'  => $rstRow['Warehouse']
    );
}

// 👉 Add Grand Total row
$data[] = array(
    'num'   => '',
    'dte'   => '',
    'sts'   => '',
    'comp'  => '<b>Grand Total:</b>',
    'inv'   => '',
    'tot'   => '<b>'.number_format($gtot,1).'</b>',
    'dis'   => '<b>'.number_format($gdis,1).'</b>',
    'ft'    => '<b>'.number_format($gft,1).'</b>',
    'st'    => '<b>'.number_format($gst,1).'</b>',
    'ntot'  => '<b>'.number_format($gntot,1).'</b>',
    'dc'    => '',
    'pc'    => '',
    'ware'  => ''
);

$cols = array(
    'num'=>'<b>S. No</b>',
    'dte'=>'<b>Date</b>',
    'sts'=>'<b>Invoice Type</b>',
    'comp'=>'<b>Company</b>',
    'inv'=>'<b>Invoice#</b>',
    'tot'=>'<b>Total</b>',
    'dis'=>'<b>Discount</b>',
    'ft'=>'<b>FED Tax</b>',
    'st'=>'<b>Sales Tax</b>',
    'ntot'=>'<b>Net Total</b>',
    'dc'=>'<b>DC#</b>',
    'pc'=>'<b>PO#</b>',
    'ware'=>'<b>Warehouse</b>'
);

$pdf->ezTable(
    $data,
    $cols,
    '',
    array(
        'xPos'=>20,
        'xOrientation'=>'right',
        'fontSize'=>9,
        'width'=>680,
        'showHeadings'=>1,
        'shaded'=>0,
        'showLines'=>2,
        'cols'=>array(
            'num'=>array('justification'=>'center','width'=>38),
            'dte'=>array('justification'=>'center','width'=>55),
            'sts'=>array('justification'=>'center','width'=>62),
            'comp'=>array('justification'=>'left','width'=>130),
            'inv'=>array('justification'=>'center','width'=>58),
            'tot'=>array('justification'=>'right','width'=>62),
            'dis'=>array('justification'=>'right','width'=>55),
            'ft'=>array('justification'=>'right','width'=>55),
            'st'=>array('justification'=>'right','width'=>55),
            'ntot'=>array('justification'=>'right','width'=>62),
            'dc'=>array('justification'=>'center','width'=>60),
            'pc'=>array('justification'=>'center','width'=>60),
            'ware'=>array('justification'=>'center','width'=>60),
        )
    )
);

//$tamt1=number_format($tamt,1);

//$pdf->ezSetDy(-20);
//$pdf->ezText("<b>Total Purchases = </b> $tamt1", 10, array("justification" => 'left'));

}



else
{
$pdf->addText(20,500,11,"<b>Company = </b>      $cmp");

$pdf->addText(20,485,11,"<b>From = </b>            $fdate <b> To: </b> $tdate ");

$count=0;
$one=1;
$nResult = MySQLi_Query($link, "Select * from p_details where Inv_Date between '$strFrom' and '$strTo' and Company='$cmp' order by Inv_Date, Inv_No  ");
$count = 0;
$data = array();

// 👉 Initialize totals
$gtot = $gdis = $gft = $gst = $gntot = 0;

while($rstRow = mysqli_fetch_array($nResult))
{
    // running totals
    $gtot  += $rstRow['Total'];
    $gdis  += $rstRow['D_Amt'];
    $gft   += $rstRow['F_Amt'];
    $gst   += $rstRow['S_Amt'];
    $gntot += $rstRow['N_Total'];

    $idate = strtotime($rstRow['Inv_Date']);
    $idate = date("d-m-Y", $idate);

    $invn = $rstRow['Inv_N'];
    if($invn == 'PIB') {
        $sts = 'Sales';
    }
    if($invn == 'PIR') {
        $sts = 'Sales Return';
    }

    $count++;
    $data[] = array(
        'num'   => $count,
        'dte'   => $idate,
        'sts'   => $sts,
        'comp'  => $rstRow['Company'],
        'inv'   => $rstRow['Inv_Det'],
        'tot'   => number_format($rstRow['Total'],1),
        'dis'   => number_format($rstRow['D_Amt'],1),
        'ft'    => number_format($rstRow['F_Amt'],1),
        'st'    => number_format($rstRow['S_Amt'],1),
        'ntot'  => number_format($rstRow['N_Total'],1),
        'dc'    => $rstRow['DC_No'],
        'pc'    => $rstRow['Pur_No'],
        'ware'  => $rstRow['Warehouse']
    );
}

// 👉 Add Grand Total row
$data[] = array(
    'num'   => '',
    'dte'   => '',
    'sts'   => '',
    'comp'  => '<b>Grand Total:</b>',
    'inv'   => '',
    'tot'   => '<b>'.number_format($gtot,1).'</b>',
    'dis'   => '<b>'.number_format($gdis,1).'</b>',
    'ft'    => '<b>'.number_format($gft,1).'</b>',
    'st'    => '<b>'.number_format($gst,1).'</b>',
    'ntot'  => '<b>'.number_format($gntot,1).'</b>',
    'dc'    => '',
    'pc'    => '',
    'ware'  => ''
);

$cols = array(
    'num'=>'<b>S. No</b>',
    'dte'=>'<b>Date</b>',
    'sts'=>'<b>Invoice Type</b>',
    'comp'=>'<b>Company</b>',
    'inv'=>'<b>Invoice#</b>',
    'tot'=>'<b>Total</b>',
    'dis'=>'<b>Discount</b>',
    'ft'=>'<b>FED Tax</b>',
    'st'=>'<b>Sales Tax</b>',
    'ntot'=>'<b>Net Total</b>',
    'dc'=>'<b>DC#</b>',
    'pc'=>'<b>PO#</b>',
    'ware'=>'<b>Warehouse</b>'
);

$pdf->ezTable(
    $data,
    $cols,
    '',
    array(
        'xPos'=>20,
        'xOrientation'=>'right',
        'fontSize'=>9,
        'width'=>680,
        'showHeadings'=>1,
        'shaded'=>0,
        'showLines'=>2,
        'cols'=>array(
            'num'=>array('justification'=>'center','width'=>38),
            'dte'=>array('justification'=>'center','width'=>55),
            'sts'=>array('justification'=>'center','width'=>62),
            'comp'=>array('justification'=>'left','width'=>130),
            'inv'=>array('justification'=>'center','width'=>58),
            'tot'=>array('justification'=>'right','width'=>62),
            'dis'=>array('justification'=>'right','width'=>55),
            'ft'=>array('justification'=>'right','width'=>55),
            'st'=>array('justification'=>'right','width'=>55),
            'ntot'=>array('justification'=>'right','width'=>62),
            'dc'=>array('justification'=>'center','width'=>60),
            'pc'=>array('justification'=>'center','width'=>60),
            'ware'=>array('justification'=>'center','width'=>60),
        )
    )
);
}





$pdf->ezSetDy(-30);


$pdf->ezText("<b>Owner GLAKB</b>", 12, array("justification" => 'right'));
ob_clean();
$pdf->ezStream();
?>



