<?php
include ('class.ezpdf.php');
include 'includes/config.php';
include 'defs.php';
$pdf = new Cezpdf('A4','portrait');
$pdf->selectFont('fonts/Times-Roman.afm');
$pdf->addJpegFromFile('images/logo1.jpg',30,740,70);
//$pdf->addText(18,750,9,"MIS GENERATED REPORT");
$date1=Date("j-n-Y");
//$pdf->ezStartPageNumbers(526, 16, 10, 'right', '', 1);
$pdf->setColor(0.72, 0.72, 0.72);
$pdf->filledRectangle(220, 770, 160, 30, 'rgb');
$pdf->setColor(0,0,0);
$pdf->addText(275,780,13,"<b>(GLAKB)</b>");
$pdf->addText(166,755,12,"<b>(CUSTOMER ACTIVITY / RECOVERY REPORT)</b>");
$pdf->ezSetDy(-110);

$prov=$_POST['sman']; 
$sman=$_POST['sman1']; 
$cust=$_POST['cust']; 

$strFrom=$_POST['strFrom'];
$strTo=$_POST['strTo'];
$bval=$_POST['aval']; 



if ($strFrom=='')
{
$nResult = MySQLi_Query($link, "select MIN(D_Date) as dte from ledgers");
while($rstRow = mysqli_fetch_array($nResult))
{
$strFrom=$rstRow['dte'];
}
}
$fdate=date('d-m-Y',strtotime($strFrom));
$tdate=date('d-m-Y',strtotime($strTo));


$strFrom=date('Y-m-d',strtotime($strFrom));
$strTo=date('Y-m-d',strtotime($strTo));





   $pdf->addText(3,710,15,"___________________________________________________________________________________________________");

$date1=Date("j-n-Y");
$pdf->addText(225,740,12,"<b>From $fdate to $tdate</b>");


if($bval!='yes' and !empty($prov))
{

$pdf->addText(30,715,12,"<b>Province:</b>      $prov");


$nResult = MySQLi_Query($link, "Select ledgers.D_Date, ledgers.Code, ledgers.vch, ledgers.Details, ledgers.Credit, ledgers.Salesman, acc_heads.Province from ledgers, acc_heads where ledgers.Code=acc_heads.Name and acc_heads.Province='$prov' and ledgers.Credit!='0.00' and ledgers.L_Type='CR' and ledgers.D_Date between '$strFrom' and '$strTo' order by D_Date, vch_number ");

$count=0;
$one=1;
$cre=0;

while($rstRow = mysqli_fetch_array($nResult))
{
    $cre += $rstRow['Credit'];
    $date = date('d-m-Y', strtotime($rstRow['D_Date']));
    $count = $one + $count;

    $data[] = array(
        'num'  => $count,
        'dte'  => $date,
        'vch'  => $rstRow['vch'],
        'name' => $rstRow['Code'],
        'rem'  => $rstRow['Details'],
        'deb'  => number_format($rstRow['Credit'], 2)
    );
}

$cols = array(
    'num'  => '<b>S. No</b>',
    'dte'  => '<b>Date</b>',
    'vch'  => '<b>Voucher#</b>',
    'name' => '<b>Account Title</b>',
    'rem'  => '<b>Narration</b>',
    'deb'  => '<b>Amount</b>'
);

$pdf->ezTable(
    $data,
    $cols,
    '',
    array(
        'xPos' => 20,
        'xOrientation' => 'right',
        'fontSize' => 10,
        'width' => 580,
        'showHeadings' => 1,
        'shaded' => 1,
        'showLines' => 1,
        'cols' => array(
            'num'  => array('justification' => 'center', 'width' => 38),
            'dte'  => array('justification' => 'center', 'width' => 60),
            'vch'  => array('justification' => 'center', 'width' => 80),
            'name' => array('justification' => 'left',   'width' => 225),
            'rem'  => array('justification' => 'left',   'width' => 100),
            'deb'  => array('justification' => 'right',  'width' => 65),
        )
    )
);

// --- Add Grand Total line after the table ---
$pdf->ezSetDy(-10); // Move down a bit
$pdf->selectFont('fonts/Helvetica-Bold.afm');
$pdf->ezText(
    "<b>Grand Total:</b> " . number_format($cre, 2),
    14, // Font size (bigger)
    array('justification' => 'left')
);

}



elseif($bval=='yes' and !empty($prov))
{
$pdf->addText(30,715,12,"<b>Province:</b>      $prov");

$pdf->addText(420,715,12,"<b>RECOVERY BY SALESMAN</b>");

$nResult = MySQLi_Query($link, "
    SELECT 
        ledgers.D_Date, 
        ledgers.Code, 
        ledgers.vch, 
        ledgers.Details, 
        ledgers.Credit, 
        ledgers.Salesman, 
        acc_heads.Province 
    FROM ledgers, acc_heads 
    WHERE ledgers.Code = acc_heads.Name 
      AND acc_heads.Province = '$prov' 
      AND ledgers.Credit != '0.00' 
      AND ledgers.L_Type = 'CR' 
      AND ledgers.D_Date BETWEEN '$strFrom' AND '$strTo' 
    ORDER BY ledgers.Salesman, ledgers.D_Date, ledgers.vch_number
");

$currentSalesman = '';
$subTotal = 0;
$grandTotal = 0;
$count = 0;
$one = 1;
$data = array();

while($rstRow = mysqli_fetch_array($nResult)) {
    $salesman = trim($rstRow['Salesman']);

    // When salesman changes, print previous table
    if($currentSalesman != '' && $salesman != $currentSalesman) {

        // Add subtotal + salesman name row
        $data[] = array(
            'num'  => '',
            'dte'  => '',
            'vch'  => '',
             'name'=>'<b>TOTAL RECOVERY (' . $currentSalesman . ')</b>',
    
            'rem'  => '',
            'deb'  => '<b>' . number_format($subTotal, 2) . '</b>'
        );

        // Define columns
        $cols = array(
            'num'=>'<b>S. No</b>', 
            'dte'=>'<b>Date</b>', 
            'vch'=>'<b>Voucher#</b>', 
            'name'=>'<b>Account Title</b>', 
            'rem'=>'<b>Narration</b>', 
            'deb'=>'<b>Amount</b>'
        );

        // Salesman header
        $pdf->ezText("<b>Salesman: $currentSalesman</b>", 12, array('justification'=>'left'));
        $pdf->ezSetDy(-10);
        $pdf->ezTable($data, $cols, '', array(
            'xPos'=>20,
            'xOrientation'=>'right',
            'fontSize'=>10,
            'width'=>580,
            'showHeadings'=>1,
            'shaded'=>1,
            'showLines'=>1,
            'cols'=>array(
                'num'=>array('justification'=>'center','width'=>38),
                'dte'=>array('justification'=>'center','width'=>60),
                'vch'=>array('justification'=>'center','width'=>80),
                'name'=>array('justification'=>'left','width'=>225),
                'rem'=>array('justification'=>'left','width'=>100),
                'deb'=>array('justification'=>'right','width'=>65),
            )
        ));

        // Reset for next salesman
        $data = array();
        $subTotal = 0;
        $pdf->ezSetDy(-10);
    }

    $currentSalesman = $salesman;
    $subTotal += $rstRow['Credit'];
    $grandTotal += $rstRow['Credit'];
    $date = date('d-m-Y', strtotime($rstRow['D_Date']));
    $count = $one + $count;

    $data[] = array(
        'num'=>$count,
        'dte'=>$date,
        'vch'=>$rstRow['vch'],
        'name'=>$rstRow['Code'],
        'rem'=>$rstRow['Details'],
        'deb'=>number_format($rstRow['Credit'],2)
    );
}

// --- Print the last salesman’s table ---
if(!empty($data)) {
    $data[] = array(
        'num'=>'',
        'dte'=>'',
        'vch'=>'',
        'name'=>'<b>TOTAL RECOVERY (' . $currentSalesman . ')</b>',
        'rem'=>'',
        'deb'=>'<b>' . number_format($subTotal,2) . '</b>'
    );

    $cols = array(
        'num'=>'<b>S. No</b>', 
        'dte'=>'<b>Date</b>', 
        'vch'=>'<b>Voucher#</b>', 
        'name'=>'<b>Account Title</b>', 
        'rem'=>'<b>Narration</b>', 
        'deb'=>'<b>Amount</b>'
    );

    $pdf->ezText("<b>Salesman: $currentSalesman</b>", 12, array('justification'=>'left'));
    $pdf->ezSetDy(-10);
        
    $pdf->ezTable($data, $cols, '', array(
        'xPos'=>20,
        'xOrientation'=>'right',
        'fontSize'=>10,
        'width'=>580,
        'showHeadings'=>1,
        'shaded'=>1,
        'showLines'=>1,
        'cols'=>array(
            'num'=>array('justification'=>'center','width'=>38),
            'dte'=>array('justification'=>'center','width'=>60),
            'vch'=>array('justification'=>'center','width'=>80),
            'name'=>array('justification'=>'left','width'=>225),
            'rem'=>array('justification'=>'left','width'=>100),
            'deb'=>array('justification'=>'right','width'=>65),
        )
    ));
}

// --- Grand Total ---
$pdf->ezSetDy(-15);
$pdf->selectFont('fonts/Helvetica-Bold.afm');
$pdf->ezText("<b>Grand Total:</b> " . number_format($grandTotal, 2), 14, array('justification'=>'left'));
}




if(!empty($sman))
{

$pdf->addText(30,715,12,"<b>Salesman:</b>      $sman");


$nResult = MySQLi_Query($link, "Select ledgers.D_Date, ledgers.Code, ledgers.vch, ledgers.Details, ledgers.Credit, ledgers.Salesman, acc_heads.Province from ledgers, acc_heads where ledgers.Code=acc_heads.Name and ledgers.Salesman='$sman' and ledgers.Credit!='0.00' and ledgers.L_Type='CR' and ledgers.D_Date between '$strFrom' and '$strTo' order by D_Date, vch_number ");

$count=0;
$one=1;
$cre=0;

while($rstRow = mysqli_fetch_array($nResult))
{
    $cre += $rstRow['Credit'];
    $date = date('d-m-Y', strtotime($rstRow['D_Date']));
    $count = $one + $count;

    $data[] = array(
        'num'  => $count,
        'dte'  => $date,
        'vch'  => $rstRow['vch'],
        'name' => $rstRow['Code'],
        'rem'  => $rstRow['Details'],
        'deb'  => number_format($rstRow['Credit'], 2)
    );
}

$cols = array(
    'num'  => '<b>S. No</b>',
    'dte'  => '<b>Date</b>',
    'vch'  => '<b>Voucher#</b>',
    'name' => '<b>Account Title</b>',
    'rem'  => '<b>Narration</b>',
    'deb'  => '<b>Amount</b>'
);

$pdf->ezTable(
    $data,
    $cols,
    '',
    array(
        'xPos' => 20,
        'xOrientation' => 'right',
        'fontSize' => 10,
        'width' => 580,
        'showHeadings' => 1,
        'shaded' => 1,
        'showLines' => 1,
        'cols' => array(
            'num'  => array('justification' => 'center', 'width' => 38),
            'dte'  => array('justification' => 'center', 'width' => 60),
            'vch'  => array('justification' => 'center', 'width' => 80),
            'name' => array('justification' => 'left',   'width' => 225),
            'rem'  => array('justification' => 'left',   'width' => 100),
            'deb'  => array('justification' => 'right',  'width' => 65),
        )
    )
);

// --- Add Grand Total line after the table ---
$pdf->ezSetDy(-10); // Move down a bit
$pdf->selectFont('fonts/Helvetica-Bold.afm');
$pdf->ezText(
    "<b>Grand Total:</b> " . number_format($cre, 2),
    14, // Font size (bigger)
    array('justification' => 'left')
);

}




if(!empty($cust))
{

$pdf->addText(30,715,12,"<b>Customer:</b>      $cust");


$nResult = MySQLi_Query($link, "Select ledgers.D_Date, ledgers.Code, ledgers.vch, ledgers.Details, ledgers.Credit, ledgers.Salesman, acc_heads.Province from ledgers, acc_heads where ledgers.Code=acc_heads.Name and ledgers.Code='$cust' and ledgers.Credit!='0.00' and ledgers.L_Type='CR' and ledgers.D_Date between '$strFrom' and '$strTo' order by D_Date, vch_number ");

$count=0;
$one=1;
$cre=0;

while($rstRow = mysqli_fetch_array($nResult))
{
    $cre += $rstRow['Credit'];
    $date = date('d-m-Y', strtotime($rstRow['D_Date']));
    $count = $one + $count;

    $data[] = array(
        'num'  => $count,
        'dte'  => $date,
        'vch'  => $rstRow['vch'],
        'name' => $rstRow['Code'],
        'rem'  => $rstRow['Details'],
        'deb'  => number_format($rstRow['Credit'], 2)
    );
}

$cols = array(
    'num'  => '<b>S. No</b>',
    'dte'  => '<b>Date</b>',
    'vch'  => '<b>Voucher#</b>',
    'name' => '<b>Account Title</b>',
    'rem'  => '<b>Narration</b>',
    'deb'  => '<b>Amount</b>'
);

$pdf->ezTable(
    $data,
    $cols,
    '',
    array(
        'xPos' => 20,
        'xOrientation' => 'right',
        'fontSize' => 10,
        'width' => 580,
        'showHeadings' => 1,
        'shaded' => 1,
        'showLines' => 1,
        'cols' => array(
            'num'  => array('justification' => 'center', 'width' => 38),
            'dte'  => array('justification' => 'center', 'width' => 60),
            'vch'  => array('justification' => 'center', 'width' => 80),
            'name' => array('justification' => 'left',   'width' => 225),
            'rem'  => array('justification' => 'left',   'width' => 100),
            'deb'  => array('justification' => 'right',  'width' => 65),
        )
    )
);

// --- Add Grand Total line after the table ---
$pdf->ezSetDy(-10); // Move down a bit
$pdf->selectFont('fonts/Helvetica-Bold.afm');
$pdf->ezText(
    "<b>Grand Total:</b> " . number_format($cre, 2),
    14, // Font size (bigger)
    array('justification' => 'left')
);

}







ob_clean();
$pdf->ezStream();
?>



