<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>AJAX Stylish Submit</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      text-align: center;
      margin-top: 100px;
    }
    .submit-btn {
      background: linear-gradient(to right, #6a11cb, #2575fc);
      border: none;
      color: white;
      padding: 15px 30px;
      font-size: 16px;
      border-radius: 8px;
      cursor: pointer;
      transition: background 0.3s ease;
    }

    .submit-btn:hover {
      background: linear-gradient(to right, #2575fc, #6a11cb);
    }

    #response {
      margin-top: 20px;
      color: green;
      font-weight: bold;
    }
  </style>
</head>
<body>

  <form id="myForm">
    <input type="text" name="name" id="name" placeholder="Enter your name" required><br><br>
    <button type="submit" class="submit-btn">Submit</button>
  </form>

  <div id="response"></div>

  <script>
    document.getElementById("myForm").addEventListener("submit", function(e) {
      e.preventDefault(); // Prevent form from submitting the traditional way

      const formData = new FormData(this);

      fetch("submit.php", {
        method: "POST",
        body: formData
      })
      .then(response => response.text())
      .then(data => {
        document.getElementById("response").innerHTML = data;
        document.getElementById("myForm").reset();
      })
      .catch(error => {
        document.getElementById("response").innerHTML = "An error occurred.";
        console.error("Error:", error);
      });
    });
  </script>

</body>
</html>
